// Header File
// Created 14/11/2003; 22:13:41
//Fonctions d'animations graphique

//Dclaration des fonctions:
void INT1_ShowLogo (void);
void INT1_BillesSpeed (void);
void INT1_BillesVarSpeed (void);
void INT1_BricksTIME (void);
void INT1_BricksMOVE (void);
void INT1_RacketsAnim (void);
void INT1_Bonus (void);
void INT1_Missiles (void);
void INT1_Missiles_anim (void);
void INT1_DoubleRacket_anim (void);
void INT1_Ghost (void);
void INT1_DoorsEndLevel (void);
void INT1_ScrollLevel (void);
void INT1_RacketsVarSpeed (void);
void INT1_MonstersAnim (void);
void INT1_MonstersSpeed (void);
void INT1_MonstersChangeDir (void);
void INT1_BlocksAnim (void);
void INT1_RacketsSpeed (void);

static unsigned short counter_fps=0;
static unsigned short counter_fps2=0;

#define __INT1_1HZ_FREQUENCY	128
static unsigned short __COUNTER_1HZ=0;
#define __INT1_80Hz_FREQUENCY	10240
static unsigned short __COUNTER_80Hz=0;

//Interruption 1
void GAME_INT1 (void);
//Interruptions
void INT1_1Hz (void);
void INT1_80Hz (void);

//Compatibilit
//355 Hz HW1
//256 Hz HW2
#define __HARDWARE										256
#define __HARDWARE_FREQUENCY					21500
static unsigned short __COUNTER_HARDWARE=0;

//Fonctions d'affichage d'animations
DEFINE_INT_HANDLER (interrupt1)
{
	//HARDWARE VERSION 1.0 
	if (HW_VERSION==1)
	{
		//Incrmentation
		__COUNTER_HARDWARE+=__HARDWARE_FREQUENCY;
		
		//Execution interrupotion
		if (__COUNTER_HARDWARE>32768)
		{
			//Remise  zro
			__COUNTER_HARDWARE-=32768;
			
			//Execute interruption
			GAME_INT1 ();
		}
		return;
	}
	
	//HARDWARE VERSION 2.0
	GAME_INT1 ();
}


//Fonctions d'affichage d'animations
void GAME_INT1 (void)
{
	//Interruption  1 Hz
	INT1_1Hz ();
	INT1_80Hz ();
	
	if (StartInt1) 
	{
		//Scrolling niveau
		INT1_ScrollLevel ();
	
		//Rglage vitesse des billes
		INT1_BillesSpeed ();
		//Variation de vitesse
		INT1_BillesVarSpeed ();
	
		//Briques spcial
		INT1_BricksTIME ();
		INT1_BricksMOVE ();
	
		//Gestion animation rackets
		INT1_RacketsAnim ();
		
		//Variation de vitesse
		INT1_RacketsVarSpeed ();
	
		//Bonus
		INT1_Bonus ();
	
		//Missiles
		INT1_Missiles ();
		INT1_Missiles_anim ();
	
		//Double racket
		INT1_DoubleRacket_anim ();
	
		//Fantme
		INT1_Ghost ();
	
		//EndLevel Doors
		INT1_DoorsEndLevel ();
		
		//Monstres
		INT1_MonstersAnim ();
		INT1_MonstersSpeed ();
		INT1_MonstersChangeDir ();
		
		//Animations blocks d'acier
		INT1_BlocksAnim ();
		
		//Gestion vitesse de dplacement
		INT1_RacketsSpeed ();
	}
}

//Interruption  1 Hz
void INT1_1Hz (void)
{
	//Compteur de variation de vitesse
	__COUNTER_1HZ+=__INT1_1HZ_FREQUENCY;
		
	//Temps coul
	if (__COUNTER_1HZ>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_1HZ-=32768;
		
		//Horloge temporaire
		delay_1Hz++;
		
		//Compteurs de frames
		counter_fps2=counter_fps;
		counter_fps=0;
		
		//Affiche logo
		INT1_ShowLogo ();
	}
}

//Inetrruption 80 Hz
void INT1_80Hz (void)
{
	//Compteur de variation de vitesse
	__COUNTER_80Hz+=__INT1_80Hz_FREQUENCY;
		
	//Temps coul
	if (__COUNTER_80Hz>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_80Hz-=32768;
	
		//Horloge temporaire
		delay_80Hz++;	
	}
}

//Animation blocks d'acier
void INT1_BlocksAnim (void)
{
	//Incrmente compteur
	__COUNTER_BLOCKS_ANIM+=__BLOCKS_ANIM_FREQUENCY;
	
	//Temps coul
	if (__COUNTER_BLOCKS_ANIM>32768)
	{
		//Rinialisation compteur
		__COUNTER_BLOCKS_ANIM-=32768;
		
		//Parcours animations
		for (int i=0; i<nbrAnimBlocks; i++)
		{
			AnimBlock_counter [i]++;
			
			if (AnimBlock_counter [i]>BLOCKS_ANIM_COUNTER)
				DeleteBlockAnim (i--);
		}
	}
}

//Scrolling level de haut en bas
void INT1_ScrollLevel (void)
{
	//Incrmente compteur
	__COUNTER_SCROLL_LEVEL_UP_DOWN+=__INT1_SCROLL_LEVEL_UP_DOWN_FREQUENCY;
	
	//Temps coul
	if (__COUNTER_SCROLL_LEVEL_UP_DOWN>32768)
	{
		//Rinialisation compteur
		__COUNTER_SCROLL_LEVEL_UP_DOWN-=32768;
		
		//Scrolling niveau
		if (!EndCounterLogo && (COUNTER_LOGO>SCROLL_LEVEL_DELAY))
		{
		  if (!ScrollLevelLogo) yScroll-=2;			//Vers le haut
		  else yScroll+=2;											//Vers le bas
		  
		  //Mouvement inverse, haut vers le bas
		  if ((yScroll<=0) && (delay_1Hz>SCROLL_LEVEL_DELAY)) ScrollLevelLogo=TRUE;
		  else if (yScroll>2) delay_1Hz=0;
		  
		  //Dpassement de capacit
			if (yScroll<0) yScroll=0;
			else if (yScroll>72) yScroll=72;		//72=200-128
		}
	}
}

//Temps d'affichage du logo
void INT1_ShowLogo (void)
{
	//Interruption
	if (!EndCounterLogo)// && StartInt1)
	{
		//Attente 1 seconde avant de faire mouvement scrolling
		COUNTER_LOGO++;
		if (COUNTER_LOGO>=LOGO_DELAY)
		EndCounterLogo=TRUE;
	}
}

//Application de la vitesse de la bille
void INT1_BillesSpeed (void)
{
	//Vitesse de la bille
	//Parcours les billes
	for (int i=0;i<nbrBille;i++)
	{
		//Compteur de vitesse
		Bille [i]->counter_update_billepos+=Bille [i]->counter_value;
		
		//Si suprieur  32768 alors remise  zro puis coeff speed=1
		if (Bille [i]->counter_update_billepos>32768)
		{
			Bille [i]->counter_update_billepos-=32768;
			Bille [i]->speed_value++;
		}
	}
}

//Variation de la vitesse de la billes
void INT1_BillesVarSpeed (void)
{
	//Compteur de variation de vitesse
	__COUNTER_VARSPEED+=__VAR_SPEED_FREQUENCY;
		
	//Temps coul
	if (__COUNTER_VARSPEED>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_VARSPEED-=32768;
		
		//Parcours billes
		for (int i=0;i<nbrBille;i++)
		{
			//Application de la variation de vitesse
			if (Bille [i]->var_speed)
			{
				//Incrmentation du compteur interne
				Bille [i]->counter_varspeed++;
				
				//Si collision
				if (Bille [i]->collide)
				{
					Bille [i]->collide=FALSE;
					
					//Si collision rapide
					if (Bille [i]->counter_varspeed<2)
						ChangeBilleSpeed (i, Bille [i]->speed+1);
						
					//Compteur interne  zro
					Bille [i]->counter_varspeed=0;
				}
			}
		}
	}
}

//Gestion de variation de vitesse
void INT1_RacketsVarSpeed (void)
{
	//Compteur de variation de vitesse
	__RACKET_VARSPEED_COUNTER+=__RACKET_VARSPEED_FREQUENCY;
		
	//Temps coul
	if (__RACKET_VARSPEED_COUNTER>32768)
	{
		//Rinitilisation du compteur
		__RACKET_VARSPEED_COUNTER-=32768;
	
		for (int i=0; i<nbrRacket; i++)
			//Position relle
			Racket [i]->xpos2=Racket [i]->xpos;
	}
}


//Gestion des briques spcial qui rapparaissent
void INT1_BricksTIME (void)
{
	//Gestion des briques spcial time
	if (MAP_StartInt1)
	{
		//Briques spcial TIME
		__MAP_COUNTER_TIME+=__MAP_FREQUENCY_TIME;
		
		//Une seconde d'couler
		if (__MAP_COUNTER_TIME>32768)
		{
			__MAP_COUNTER_TIME-=32768;
			
			for (unsigned short i=0;i<bricks_special_time_n;i++)
			{
				//Si brique cass incrmenter compteur
				if ((LevelMap [MAP_bricks_special_time_y[i]][MAP_bricks_special_time_x[i]]&0x0F)==0) MAP_bricks_special_time_c[i]++;
			}
		}
	}	
}

//Gestions briques qui ce dplace
void INT1_BricksMOVE (void)
{
	//Gestion des briques spcial time
	if (MAP_StartInt1)
	{
		//Briques spcial MOVE
		__MAP_COUNTER_MOVE+=__MAP_FREQUENCY_MOVE;
		
		//10 Hz
		if (__MAP_COUNTER_MOVE>32768)
		{
			__MAP_COUNTER_MOVE-=32768;
			
			short x,y;
			for (unsigned short i=0;i<bricks_special_move_n;i++)
			{
				//Si brique non cass ou bouge pas
				if ((!MAP_bricks_special_move_destroy [i]) && (MAP_bricks_special_move_dep [i]))
				{
					//Collisions avec les autres briques
					MAP_bricks_special_move_x [i]+=MAP_bricks_special_move_dir [i];
					
					//Brique y dans LevelMap
					y=(MAP_bricks_special_move_y [i]-BLOCK_SIZEY)/7;
					
					//Collision vers la droite
					if (MAP_bricks_special_move_dir [i]==1)
					{
						//Brique suivante x
						x=(MAP_bricks_special_move_x [i]+START_X-1)>>4;
						
						if ((LevelMap [y][x]&0x0F)!=0)
						{
							//Inverse direction
							MAP_bricks_special_move_dir [i]*=-1;
							MAP_bricks_special_move_x [i]+=MAP_bricks_special_move_dir [i];
						}
					}
					//Collision vers la gauche
					else
					{
						//Brique suivante x
						x=abs ((MAP_bricks_special_move_x [i]+START_X)-BLOCK_SIZEX)>>4;
						
						if ((LevelMap [y][x]&0x0F)!=0)
						{
							//Inverse direction
							MAP_bricks_special_move_dir [i]*=-1;
							MAP_bricks_special_move_x [i]+=MAP_bricks_special_move_dir [i];
						}
					}
					
					//Collisions avec l'cran
					if ((MAP_bricks_special_move_x [i]<START_X) || ((MAP_bricks_special_move_x [i]+BLOCK_SIZEX)>GAME_WIDTH))
					{
						MAP_bricks_special_move_dir [i]*=-1;
						MAP_bricks_special_move_x [i]+=MAP_bricks_special_move_dir [i];
					}
					
					//Collisions avec voisines
					for (unsigned short j=0;j<bricks_special_move_n;j++)
					{
						//Si brique non cass
						if ((!MAP_bricks_special_move_destroy [j]) && (i!=j))
						{
							//Collision
							if (((MAP_bricks_special_move_x [i]==(MAP_bricks_special_move_x [j]+BLOCK_SIZEX-1)) || ((MAP_bricks_special_move_x [i]+BLOCK_SIZEX)==(MAP_bricks_special_move_x [j]+1))) && (MAP_bricks_special_move_y [i]==MAP_bricks_special_move_y [j]))
							{	
								MAP_bricks_special_move_dir [j]=MAP_bricks_special_move_dir [i];
								
								MAP_bricks_special_move_dir [i]*=-1;
								MAP_bricks_special_move_x [i]+=MAP_bricks_special_move_dir [i];
							}
						}
					}
				}
			}
		}
	}
}

//Animation raquettes
void INT1_RacketsAnim (void)
{
	unsigned char racket_size;
	
	//Animations des rackets
	//Compteurs d'affichage de sprite
	__RACKET_ANIM_COUNTER+=__RACKET_ANIM_FREQUENCY;
		
	if (Rackets_anim)
	{
		//Nouveau sprite
		if (__RACKET_ANIM_COUNTER>32768)
		{
			//Remise  zro du compteur
			__RACKET_ANIM_COUNTER-=32768;
			
			//Parcours rackets
			for (int i=0;i<nbrRacket;i++)
			{
				//--GAME--
				if (Racket [i]->new_==-1)	//Pas d'animations spcial
				{
					//Sprite suivant
					if (Racket [i]->sprite_anim==3) Racket [i]->sprite_anim=0;
					else Racket [i]->sprite_anim++;
				}
				
				//--ANIMATIONS--
				else if (Racket [i]->new_<7)
				{
					racket_size=Racket [i]->Tbl_anims [0][Racket [i]->Tbl_item];
				
					//Direction (incrmentation)
					if (Racket [i]->Tbl_anims [1][Racket [i]->Tbl_item]==1)
					{
						if (((((racket_size==4) || (racket_size==5)) && (Racket [i]->sprite_anim==3))) || (Racket [i]->sprite_anim==5)) 
						{
							//Incrmente animations
							Racket [i]->Tbl_item++;
						
							//Animation  0
							Racket [i]->sprite_anim=0;
						}
						else Racket [i]->sprite_anim++; //++
					}
					//Direction (dcrmentation)
					else
					{
						//Animation <0
						if (!Racket [i]->sprite_anim)
						{
							//Incrmente animations
							Racket [i]->Tbl_item++;
						
							//Animation  0
							//Racket [i]->sprite_anim=0;
						}
						else Racket [i]->sprite_anim--; //--
					}
				
					//Si Tbl_item=2 ou =1 avec une animation
					if ((Racket [i]->Tbl_item==2) || ((Racket [i]->Tbl_item==1) && (!Racket [i]->Tbl_anims [0][1])))
					{
						//Fin animation nouvelle racket
						Racket [i]->size=Racket [i]->new_;
						Racket [i]->sprite=Racket [i]->new_;
					
						//Taille x
						Racket [i]->size_x=RACKETS_GAME_size [Racket [i]->new_];
						Racket [i]->size_x2=Racket [i]->size_x-1;
					
						//Fin interruption animations
						Racket [i]->new_=-1;
					}
					
					//Passage sprite...
					else
					{
						//Sprite
						Racket [i]->sprite=Racket [i]->Tbl_anims [0][Racket [i]->Tbl_item];
						Racket [i]->size=Racket [i]->sprite;
					
						//Taille x
						Racket [i]->size_x=RACKETS_ANIMS_size [Racket [i]->sprite-4][Racket [i]->sprite_anim];
						Racket [i]->size_x2=Racket [i]->size_x-1;
					}
				}
				//Animation spcial NEW ou DEAD
				else
				{					
					//Si dpassement animation
					if (Racket [i]->sprite_anim==4)
					{
						//Effacer racket
						if (Racket [i]->size==7)
							DestroyRacket (i--);
						else {
							Racket [i]->new_=-1;
							Racket [i]->size=1;
							Racket [i]->sprite_anim=0;
							Racket [i]->size_x=29;
							Racket [i]->size_x2=28;
							Racket [i]->size_y=9;
							Racket [i]->size_y2=8;
							Racket [i]->sprite=1;
						
							if (i==HUMAIN0) EndAnimForHumain0=TRUE;}	
					}
					else
						//Incrmente sprite
						Racket [i]->sprite_anim++;
				}
			}
		}
	}
}

//Bonus
void INT1_Bonus (void)
{
	//Compteur interruption
	__COUNTER_BONUS+=__INT1_BONUS_FREQUENCY;
	
	//Temps coul
	if (__COUNTER_BONUS>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_BONUS-=32768;
			
		if (INT_START_BONUS)
		{
			//Parcours Bonus
			for (int i=0;i<nbrBonus;i++)
			{
				BONUS_ypos [i]+=2;					
					
				//Dpassement
				if ((BONUS_ypos [i]+BONUS_HEIGHT2)>GAME_HEIGHT2) BONUS_ypos[i]=GAME_HEIGHT2-BONUS_HEIGHT2;
				
				BONUS_SHOWANIM [i]++;
				
				//Affichage animation
				if (BONUS_SHOWANIM [i]>=4)
				{
					BONUS_SPRITE_ANIM [i]=(BONUS_SPRITE_ANIM [i]+1)&0x07;
					BONUS_SHOWANIM [i]=0;
				}
			}
		}
	}
}

//Missiles
void INT1_Missiles (void)
{
	//Compteur interruption
	__COUNTER_MISSILES+=__INT1_MISSILES_FREQUENCY;
		
	//Temps coul
	if (__COUNTER_MISSILES>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_MISSILES-=32768;
	
		//Parcours Missiles
		for (int i=0;i<nbrMissile;i++)
		{
			MISSILE_ypos [i]-=3;
			
			//Dpassement
			if (MISSILE_ypos [i]<START_Y)
				MISSILE_ypos [i]=START_Y;
		}
		
		//Interval entre chaque tir
		if (StartIntMissiles)
		{
			//Parcours rackets et incrmente compteur
			for (int i=0;i<nbrRacket;i++)
				Racket [i]->COUNTER_MISSILE_TIME_SHOOT++;
		}
	}
}

//Animation Missiles
void INT1_Missiles_anim (void)
{
	//Compteur interruption
	__COUNTER_MISSILES_ANIM+=__INT1_MISSILES_ANIM_FREQUENCY;
		
	//Temps coul
	if (__COUNTER_MISSILES_ANIM>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_MISSILES_ANIM-=32768;
			
		//interruption Missile
		if (StartIntMissiles)
		{
			//Parcours Missiles
			for (int i=0;i<nbrMissile_anim;i++)
			{
				//Dpassement de sprite
				if (MISSILE_ANIM_sprite [i]>=2)
					DELETE_ANIM_MISSILE (i--);
				else
					//Incrmente sprite
					MISSILE_ANIM_sprite [i]++;	
			}
		}
	}
}

//Animation Double raquette
void INT1_DoubleRacket_anim (void)
{
	if (StartIntDoubleRacket)
	{
		//Compteur interruption
		__COUNTER_DOUBLE_RACKET_ANIM+=__INT1_DOUBLE_RACKET_ANIM_FREQUENCY;
		
		//Temps coul
		if (__COUNTER_DOUBLE_RACKET_ANIM>32768)
		{
			//Rinitilisation du compteur
			__COUNTER_DOUBLE_RACKET_ANIM-=32768;
		
			//Parcours racket
			for (int i=0;i<nbrRacket;i++)
			{
				//Si animation
				if (Racket [i]->double_racket_anim && !Racket [i]->isDoubleRacket)
				{
					Racket [i]->double_xpos+=Racket [i]->double_dir;
					
					//Animation  l'envers, retire racket
					if (Racket [i]->double_xpos<=0)
						Racket [i]->double_racket_anim=FALSE;
					//Animation  l'endroit, ajoute racket
					else if (Racket [i]->double_xpos==36)
					{
						AddDoubleRacket (i);
						Racket [i]->double_racket_anim=FALSE;
						i++;
					}
				}
			}
		}
	}
}

//Animation Bonus Ghost
void INT1_Ghost (void)
{
	if (StartIntGhost)
	{
		//Compteur interruption
		__COUNTER_GHOST+=__INT1_GHOST_FREQUENCY;
		
		//Temps coul
		if (__COUNTER_GHOST>32768)
		{
			//Rinitilisation du compteur
			__COUNTER_GHOST-=32768;
			
			//Parcours rackets
			for (int i=0;i<nbrRacket;i++)
			{
				//Si mode Ghost
				if (Racket [i]->ghost && Racket [i]->ShowGhost && (!Racket [i]->ghost_key))
				{
					//Si xpos=0
					if (Racket [i]->ghost_xpos<=13)
					{
						Racket [i]->ghost_dir=1;
						Racket [i]->ShowGhost=FALSE;
					}
					else
						//Animation
						Racket [i]->ghost_xpos-=2;
				}
			}	
		}
	}
}

//Animation DoorsEndLevel
void INT1_DoorsEndLevel (void)
{
	//Compteur interruption
	__COUNTER_DOORS_ENDLEVEL+=__INT1_DOORS_ENDLEVEL_FREQUENCY;
	
	//Temps coul
	if (__COUNTER_DOORS_ENDLEVEL>32768)
	{
		//Rinitilisation du compteur
		__COUNTER_DOORS_ENDLEVEL-=32768;
	
		if (EndLevel)
		{
			//Sprite
			EndLevel_Sprite++;
		
			if (EndLevel_Sprite>2) EndLevel_Sprite=0;
		
			if (PlayAnimEndLevel)
			{
				AnimEndLevel_x--;
				
				if (AnimEndLevel_x<0) PlayAnimEndLevel=FALSE;
			}
		}
	}
}

//Animation des monstres
void INT1_MonstersAnim (void)
{
	if (StartIntMonster)
	{
		//Compteur interruption
		__COUNTER_MONSTER_ANIM+=__MONSTER_ANIM_FREQUENCY;
	
		//Temps coul
		if (__COUNTER_MONSTER_ANIM>32768)
		{
			//Rinitilisation du compteur
			__COUNTER_MONSTER_ANIM-=32768;
			
			//Parcours monstres
			for (int i=0;i<nbrMonster;i++)
			{ 
			  //Sprite suivant
			  Monster [i]->sprite++;	
			  
			  //Modulo
			  if (Monster [i]->sprite>=Monster [i]->sprite_end)
			  {
			    if (Monster [i]->dead) DeleteMonster (i--);
			    else Monster [i]->sprite=0;
			  }		  
			}
		}
	}
}

//Application de la vitesse d'un mosntre
void INT1_MonstersSpeed (void)
{
	if (StartIntMonster)
	{
		//Parcours les monstres
		for (int i=0;i<nbrMonster;i++)
		{
			//Compteur de vitesse
			Monster [i]->counter_update_monsterpos+=Monster [i]->counter_value;
		
			//Si suprieur  32768 alors remise  zro puis coeff speed=1
			if (Monster [i]->counter_update_monsterpos>32768)
			{
				Monster [i]->counter_update_monsterpos-=32768;
				Monster [i]->speed_value++;
			}
		}
	}
}

//Force un monstre  ce diriger vers le bas
void INT1_MonstersChangeDir (void)
{
	if (StartIntMonster)
	{
		//Compteur interruption
		__COUNTER_MONSTER_DIR+=__MONSTER_DIR_FREQUENCY;
	
		//Temps coul
		if (__COUNTER_MONSTER_DIR>32768)
		{
			//Rinitilisation du compteur
			__COUNTER_MONSTER_DIR-=32768;
			
			//Parcours monstres
			for (int i=0;i<nbrMonster;i++)
			{
				if (GCL_Random (2))
				{
					Monster [i]->xmove=0;
					Monster [i]->ymove=1;
				}
				else if (GCL_Random (2))
				{
					Monster [i]->ymove=0;
					if (GCL_Random (2))
						Monster [i]->xmove=1;
					else
						Monster [i]->xmove=-1;
				}
			}
		}
	}
}

//Gestion vitesse de dplacement
void INT1_RacketsSpeed (void)
{
	//Parcours les rackets
	for (int i=0;i<nbrRacket;i++)
	{
		//Compteur de vitesse
		Racket [i]->counter_update_racketpos+=Racket [i]->counter_value;
		
		//Si suprieur  32768 alors remise  zro puis coeff speed=1
		if (Racket [i]->counter_update_racketpos>32768)
		{
			Racket [i]->counter_update_racketpos-=32768;
			Racket [i]->speed_value++;
		}
	}
}